<?php 
include '../../connection.php'; 

$message = ''; // Initialize a message variable

// Check if ID is provided in the URL
if (!isset($_GET['id'])) {
    header("Location: index.php"); // Redirect if no ID is provided
    exit();
}

$id = $_GET['id'];

$sqlRetrieve = "SELECT * FROM banking WHERE id = ?";
$stmtRetrieve = $con->prepare($sqlRetrieve);

if ($stmtRetrieve === false) {
    die('Prepare failed: ' . htmlspecialchars($con->error));
}

$stmtRetrieve->bind_param("i", $id);
$stmtRetrieve->execute();
$result = $stmtRetrieve->get_result();
$row = $result->fetch_assoc();

$stmtRetrieve->close();

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Retrieve form data
    $bank_name = $_POST['bank_name'];
    $holder_name = $_POST['holder_name'];
    $account_no = $_POST['account_no'];
    $mobile = $_POST['mobile'];
    $amount = $_POST['amount'];
    $branch_name = $_POST['branch_name'];
    $district = $_POST['district'];
    $status = $_POST['status']; // New status field

    // Update the banking_requests table
    $sqlUpdate = "UPDATE banking SET bank_name = ?, holder_name = ?, account_no = ?, mobile = ?, amount = ?, branch_name = ?, district = ?, status = ? WHERE id = ?";
    $stmtUpdate = $con->prepare($sqlUpdate);

    if ($stmtUpdate === false) {
        die('Prepare failed: ' . htmlspecialchars($con->error));
    }

    $stmtUpdate->bind_param("ssssssssi", $bank_name, $holder_name, $account_no, $mobile, $amount, $branch_name, $district, $status, $id);

    if ($stmtUpdate->execute()) {
        if ($stmtUpdate->affected_rows > 0) { // Check if any rows were updated
            // If status is accepted, deduct the amount from user's balance
            if ($status === 'Accepted') {
                $userid = $row['userid']; // Assuming you have userid in the banking table

                $sqlDeductBalance = "UPDATE balance SET amount = amount - ? WHERE userid = ?";
                $stmtDeductBalance = $con->prepare($sqlDeductBalance);

                if ($stmtDeductBalance === false) {
                    die('Prepare failed: ' . htmlspecialchars($con->error));
                }

                $stmtDeductBalance->bind_param("di", $amount, $userid);

                if (!$stmtDeductBalance->execute()) {
                    $message = "Failed to update balance.";
                }

                $stmtDeductBalance->close();

                // Insert notification for accepted status
                $messageContent = ' এডমিন  আপনার  ব্যাংকিং সেবা  রিকোয়েস্টটি   গ্রহণ ও সম্পন্ন করেছেন ';
                $notificationStatus = 'Unread';
                $date = date('Y-m-d'); // Get current date and time

                $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date) VALUES (?, ?, ?, ?)";
                $stmtInsertNotification = $con->prepare($sqlInsertNotification);

                if ($stmtInsertNotification === false) {
                    die('Prepare failed: ' . htmlspecialchars($con->error));
                }

                $stmtInsertNotification->bind_param("isss", $userid, $messageContent, $notificationStatus, $date);
                $stmtInsertNotification->execute();
                $stmtInsertNotification->close();
            } elseif ($status === 'Rejected') {
                // Insert notification for rejected status
                $userid = $row['userid']; // Assuming you have userid in the banking table
                $messageContent = ' এডমিন  আপনার  ব্যাংকিং সেবা রিকোয়েস্টটি   বাতিল করেছেন ';
                $notificationStatus = 'Unread';
                $date = date('Y-m-d'); // Get current date and time

                $sqlInsertNotification = "INSERT INTO notification (userid, message, status, date) VALUES (?, ?, ?, ?)";
                $stmtInsertNotification = $con->prepare($sqlInsertNotification);

                if ($stmtInsertNotification === false) {
                    die('Prepare failed: ' . htmlspecialchars($con->error));
                }

                $stmtInsertNotification->bind_param("isss", $userid, $messageContent, $notificationStatus, $date);
                $stmtInsertNotification->execute();
                $stmtInsertNotification->close();
            }

            header("Location: banking-rqst.php");
            $message = "Update successful.";
        } else {
            $message = "No changes made.";
        }
    } else {
        $message = "Error updating record: " . htmlspecialchars($stmtUpdate->error);
    }

    $stmtUpdate->close();
}
?>


<?php include 'header-link.php'; ?>
<?php include 'nav-bar.php'; ?>
<?php include 'header-top-chat.php'; ?>

<!-- [ Main Content ] start -->
<div class="pcoded-main-container">
    <div class="pcoded-wrapper">
        <div class="pcoded-content">
            <div class="pcoded-inner-content">
                <div class="main-body">
                    <div class="page-wrapper">
                        <!-- [ breadcrumb ] start -->
                        <div class="page-header text-center">
                            <div class="page-block">
                                <div class="row align-items-center">
                                    <div class="col-md-12">
                                        <div class="page-header-title">
                                            <h5 class="m-b-10"> Banking Request Approval</h5>
                                            <!-- show error message here -->
                                            <?php if ($message): ?>
                                                <div class="alert alert-info"><?php echo htmlspecialchars($message); ?></div>
                                            <?php endif; ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] start -->
                        <div class="row justify-content-center">
                            <!-- [ form-element ] start -->
                            <div class="col-lg-6">
                                <div class="card">
                                    <div class="card-header">
                                        <h5> Request Approval</h5>
                                    </div>
                                    <div class="card-body">
                                        <form method="POST">
                                            <div class="form-group">
                                                <label class="form-label"> Bank Name </label>
                                                <input type="text" name="bank_name" class="form-control" value="<?php echo htmlspecialchars($row['bank_name']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> Holder Name </label>
                                                <input type="text" name="holder_name" class="form-control" value="<?php echo htmlspecialchars($row['holder_name']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> Account No </label>
                                                <input type="text" name="account_no" class="form-control" value="<?php echo htmlspecialchars($row['account_no']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> Mobile No </label>
                                                <input type="text" name="mobile" class="form-control" value="<?php echo htmlspecialchars($row['mobile']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> Amount </label>
                                                <input type="number" name="amount" class="form-control" value="<?php echo htmlspecialchars($row['amount']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> Branch Name </label>
                                                <input type="text" name="branch_name" class="form-control" value="<?php echo htmlspecialchars($row['branch_name']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> District </label>
                                                <input type="text" name="district" class="form-control" value="<?php echo htmlspecialchars($row['district']); ?>" required>
                                            </div>

                                            <div class="form-group">
                                                <label class="form-label"> Choose Status </label>
                                                <select name="status" class="form-select form-control" required>
                                                    <option value="Pending" <?php echo $row['status'] === 'Pending' ? 'selected' : ''; ?>>Pending</option>
                                                    <option value="Accepted" <?php echo $row['status'] === 'Accepted' ? 'selected' : ''; ?>>Accepted</option>
													<option value="Rejected" <?php echo $row['status'] === 'Rejected' ? 'selected' : ''; ?>>Rejected</option>
                                                </select>
                                            </div>

                                            <div class="card-footer">
                                                <button type="submit" class="btn btn-primary me-2">Submit</button>
                                                <a class="btn btn-light" href="index.php"> Go Back </a>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- [ Main Content ] end -->
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- [ Main Content ] end -->

<?php include 'footer.php'; ?>
